import React from 'react';
import { Grid } from '@crm/components/dist/Attribute2/components/Grid';
import { StatefulStaffSuggestMultiple } from './StatefulStaffSuggestMultiple';
import { User } from '../types/User';
import { genUser } from '../utils/genUser';

const users: User[] = [
  genUser({
    id: 1,
    name: 'Илья Блинков',
    login: 'blinkovilya',
    group: {
      name: 'Группа 1',
    },
  }),
  genUser({
    id: 2,
    name: 'Наталья Исаева',
    login: 'nataliaisaeva',
    group: {
      name: 'Группа 1432 423 4123 123 45234 123 123 123 13',
    },
  }),
  genUser({
    id: 3,
    name: 'Кирилл Шаповалов',
    login: 'shkrll',
    group: {
      name: 'Группа 5',
    },
  }),
  genUser({
    id: 4,
    name: 'Евгений Хромков',
    login: 'jk76',
    group: {
      name: 'Группа 1432 423 41233',
    },
  }),
  genUser({
    id: 5,
    name: 'Юлия Трухачёва',
    login: 'yuliased',
    group: {
      name: 'Группа 14323 123 123 13',
    },
  }),
];

const loadUsers = (text: string) => {
  return new Promise<User[]>((resolve) => {
    setTimeout(() => {
      resolve(users.filter((user) => user.name.includes(text)));
    }, 800);
  });
};

export const Default = () => {
  return (
    <div style={{ padding: '400px 0' }}>
      <Grid>
        <StatefulStaffSuggestMultiple
          label="Наблюдатели"
          onLoad={loadUsers}
          defaultValue={[...users]}
        />
        <StatefulStaffSuggestMultiple
          label="Исполнители"
          onLoad={loadUsers}
          defaultValue={[users[2]]}
        />
      </Grid>

      <button>index</button>
    </div>
  );
};

export default {
  title: 'Attribute2/StaffSuggestMultiple',
};
