import React, { FC, useCallback } from 'react';
import cx from 'classnames';
import { BubbleProps } from '@crm/components/dist/Bubble';
import {
  SuggestSelectMultiple,
  RenderReadingRowProps,
} from '@crm/components/dist/Attribute2/SuggestSelectMultiple';
import { StaffSuggestMultipleProps } from './StaffSuggestMultiple.types';

import { ReadingRowUser } from '../components/ReadingRowUser';
import css from './StaffSuggestMultiple.module.css';
import { User } from '../types/User';
import { handleUsersLoad } from './StaffSuggestMultiple.utils';
import { SelectedBubbleUser } from '../../SelectedBubbleUser';
import { PopupItemUser } from '../../PopupItemUser';

const getKey = (user: User) => user.id;
const renderReadingRow = (user: User, props: RenderReadingRowProps) => (
  <ReadingRowUser user={user} onClick={props.onEssentialClick} isDisabled />
);
const renderSelectedBubble = (user: User, props: BubbleProps) => (
  <SelectedBubbleUser
    user={user}
    className={cx(props.className, css.StaffSuggestMultiple__selectedBubble)}
    {...props}
    canDelete
  />
);
const renderPopupItem = (user: User) => <PopupItemUser user={user} />;

export const StaffSuggestMultiple: FC<StaffSuggestMultipleProps> = (props) => {
  const { onLoad, mergeCurrentUserIntoList = true, currentUser } = props;

  const handleLoad = useCallback(
    (text: string): User[] | Promise<User[]> => {
      const users = onLoad?.(text) || [];

      if (!mergeCurrentUserIntoList || !currentUser) {
        return users;
      }

      if (Array.isArray(users)) {
        return handleUsersLoad({
          text,
          users,
          currentUser,
        });
      }

      return users.then((data) =>
        handleUsersLoad({
          text,
          users: data,
          currentUser,
        }),
      );
    },
    [onLoad],
  );

  return (
    <SuggestSelectMultiple<User>
      {...props}
      onLoad={handleLoad}
      getKey={getKey}
      renderReadingRow={renderReadingRow}
      renderSelectedBubble={renderSelectedBubble}
      renderPopupItem={renderPopupItem}
    />
  );
};
