import { User } from '../types/User';

export const handleUsersLoad = (payload: {
  currentUser: User;
  users: User[];
  text: string;
}): User[] => {
  const { currentUser, users: rawUsers, text } = payload;
  const users = rawUsers.slice();

  if (!users.length) {
    return users;
  }

  const index = users.findIndex((user) => user.id === currentUser.id);
  if (index !== -1) {
    users.splice(index, 1);
    return [currentUser, ...users];
  }

  if (!text) {
    return [currentUser, ...users];
  }

  return users;
};
