import React, { FC, useState } from 'react';
import { StatefulStaffSuggestMultipleProps } from './StaffSuggestMultiple.types';
import { StaffSuggestMultiple } from './StaffSuggestMultiple';
import { User } from '../types/User';

export const StatefulStaffSuggestMultiple: FC<StatefulStaffSuggestMultipleProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<User[]>(props.defaultValue);

  return (
    <StaffSuggestMultiple
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      onChange={setValue}
    />
  );
};
