import React, { FC, useCallback } from 'react';
import { TagBubble } from 'components/TagBubble';
import { Label } from '@crm/components/dist/Attribute2/components/Label';
import { Value } from '@crm/components/dist/Attribute2/components/Value';
import { KeyValueReading } from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { TagsReadingProps } from '../Tags.types';

export const Reading: FC<TagsReadingProps> = (props) => {
  const { readingValue, label, isReadingLoading } = props;
  const renderKeyValue = useCallback(() => {
    const hasValue = Array.isArray(readingValue) && readingValue.length > 0;
    const padding = hasValue ? '4px 12px' : '7px 12px';

    return (
      <>
        <Label>{label}</Label>
        <Value padding={padding} isEmpty={!hasValue} isLoading={isReadingLoading}>
          {readingValue.map((tag) => (
            <TagBubble enableFocusStyles={false} key={tag.id} tag={tag} />
          ))}
        </Value>
      </>
    );
  }, [readingValue, label, isReadingLoading]);

  return <KeyValueReading {...props} render={renderKeyValue} />;
};
