import React, { useState, FC } from 'react';
import { StatefulTagsProps, TagsEditingValue } from './Tags.types';
import { Tags } from './Tags';

export const StatefulTags: FC<StatefulTagsProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<TagsEditingValue>(props.defaultValue);

  return (
    <Tags
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      onChange={setValue}
    />
  );
};
