import React from 'react';
import { Grid } from '@crm/components/dist/Attribute2/components/Grid';
import { StatefulTags } from './StatefulTags';
import { Tag } from './Tags.types';

const tags: Tag[] = [
  {
    id: 1,
    text: 'Personal tag',
    type: 'Personal',
    color: '#FFE4A4',
  },
  {
    id: 2,
    text: 'Common tag',
    type: 'Shared',
    color: '#A8D4FF',
  },
  {
    id: 3,
    text: 'Common tag Common tag Common tag Common tag Common tag Common tag Common tag',
    type: 'Shared',
  },
  {
    id: 4,
    text:
      'personal tag personal tag personal tag personal tag personal tag personal tag personal tag',
    type: 'Personal',
    color: '#97E6AF',
  },
];

const wait = (ms: number) => new Promise<void>((resolve) => setTimeout(resolve, ms));

const loadTags = async (text: string) => {
  await wait(800);
  return tags.filter((tag) => tag.text.includes(text));
};

export const Default = () => {
  return (
    <div style={{ padding: '400px 0' }}>
      <Grid>
        <StatefulTags label="Теги" onLoad={loadTags} defaultValue={[tags[1]]} />
        <StatefulTags label="Теги" onLoad={loadTags} defaultValue={[tags[2]]} />
        <StatefulTags label="Теги" onLoad={loadTags} defaultValue={[tags[1]]} />
      </Grid>

      <button>index</button>
    </div>
  );
};

export default {
  title: 'Attribute2/Tags',
};
