import { EntireProps } from '@crm/components/dist/Attribute2/types/EntireProps';
import { EditingProps } from '@crm/components/dist/Attribute2/types/EditingProps';
import { ReadingProps } from '@crm/components/dist/Attribute2/types/ReadingProps';
import { StatefulProps } from '@crm/components/dist/Attribute2/types/StatefulProps';
import { Bubble } from '@crm/components/dist/Attribute2/types/Bubble';

export type Tag = Bubble & {
  type: 'Shared' | 'Personal';
};

export type TagsReadingValue = Tag[];
export type TagsEditingValue = Tag[];

export interface TagsEditingProps extends EditingProps<TagsEditingValue> {
  onLoad?: (text: string) => Tag[] | Promise<Tag[]>;
}
export type TagsReadingProps = ReadingProps<TagsReadingValue>;

export type TagsProps = EntireProps<TagsReadingProps, TagsEditingProps>;
export type StatefulTagsProps = StatefulProps<TagsProps>;
