import React, { FC, useCallback, useRef } from 'react';
import { useKeyboard } from '@crm/components/dist/useKeyboard';
import { useOutsideClick } from '@crm/components/dist/useOutsideClick';
import { BubblesContainer } from '@crm/components/dist/BubblesContainer';
import { EditingArea } from '@crm/components/dist/Attribute2/components/EditingArea';
import { TimerEditingProps } from '../Timer.types';
import { TimerBubble } from '../TimerBubble';

export const Editing: FC<TimerEditingProps> = (props) => {
  const {
    tabIndex,
    editingRef,
    display = false,
    editingValue,
    onEditingChange,
    onChange,
    onExistingTimerClick,
    isModalVisible,
    name,
  } = props;

  const editingAreaRef = useRef<HTMLDivElement>();

  useOutsideClick(
    editingAreaRef,
    useCallback(() => {
      if (display && !isModalVisible) {
        onEditingChange?.(false);
      }
    }, [display, isModalVisible]),
  );

  const handleBubbleDelete = useCallback(() => {
    onChange?.(null);
  }, [onChange]);

  const handleInnerRef = useCallback(
    (instance: HTMLDivElement) => {
      editingAreaRef.current = instance;
      editingRef?.(instance);
    },
    [editingRef],
  );

  useKeyboard(
    {
      onEsc: () => onEditingChange?.(false),
      onTab: (event) => event.preventDefault(),
      onBackspace: () => {
        if (isModalVisible) {
          return;
        }

        onChange?.(null);
      },
    },
    display,
    [onEditingChange, onChange, isModalVisible],
  );

  return (
    <EditingArea name={name} display={display} innerRef={handleInnerRef} tabIndex={tabIndex}>
      <BubblesContainer>
        {editingValue && (
          <TimerBubble
            timer={editingValue}
            cursor="pointer"
            onClick={onExistingTimerClick}
            canDelete
            onDelete={handleBubbleDelete}
          />
        )}
      </BubblesContainer>
    </EditingArea>
  );
};
