import React, { FC, useCallback } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import Tooltip from 'lego/components/ToolTip';
import { UserLink } from 'components/UserLink';
import { GridTemplate } from '@crm/components/dist/Attribute2/components/GridTemplate';
import { Label } from '@crm/components/dist/Attribute2/components/Label';
import { Value } from '@crm/components/dist/Attribute2/components/Value';
import {
  KeyValueReading,
  RenderProps,
} from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { TimerReadingProps } from '../Timer.types';
import { prettyDate, actionToString } from '../Timer.utils';
import css from './Reading.module.css';
import { TimerInfo } from '../TimerInfo';
import { modifiers } from './Reading.config';

export const Reading: FC<TimerReadingProps> = (props) => {
  const { readingValue, label, isReadingLoading } = props;

  const showTooltip = Boolean(readingValue?.users?.length || readingValue?.comment?.length);

  const renderKeyValue = useCallback(
    (props: RenderProps) => {
      return (
        <>
          <Tooltip
            className={css.Reading__tooltip}
            autoZIndex
            showDelay={300}
            hideDelay={300}
            hasTail={false}
            directions={['bottom', 'top']}
            modifiers={modifiers}
            keepMounted
            tooltip={readingValue && showTooltip && <TimerInfo timer={readingValue} />}
            stopPropagation
          >
            <GridTemplate>
              <Label>{label}</Label>
              <Value
                className={css.Reading__value}
                padding="7px 12px"
                isLoading={isReadingLoading}
                isEmpty={!readingValue}
              >
                {readingValue && (
                  <>
                    <Text typography="body-short-m">{prettyDate(readingValue.activationDate)}</Text>
                    <Text color="secondary" typography="body-short-m">
                      {actionToString(readingValue.action)}
                    </Text>
                    <UserLink user={readingValue.author} onClick={props.onEssentialClick} />
                  </>
                )}
              </Value>
            </GridTemplate>
          </Tooltip>
        </>
      );
    },
    [label, readingValue, isReadingLoading],
  );

  return <KeyValueReading {...props} render={renderKeyValue} />;
};
