import React, { FC, useState, useCallback } from 'react';
import { Timer } from './Timer';
import { StatefulTimerProps, TimerEditingValue } from './Timer.types';

export const StatefulTimer: FC<StatefulTimerProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<TimerEditingValue>(props.defaultValue);

  const handleChange = useCallback((newValue: TimerEditingValue) => {
    setValue(newValue);
    setEditing(false);
  }, []);

  return (
    <Timer
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      label={props.label}
      readingValue={value}
      editingValue={value}
      onChange={handleChange}
    />
  );
};
