import React from 'react';
import { StatefulTimer } from './StatefulTimer';
import { Grid } from '@crm/components/dist/Attribute2/components/Grid';
import { Timer } from './Timer';
import { genUser } from '../utils/genUser';

const date = new Date();
date.setMonth(3);

export const Default = () => {
  return (
    <div style={{ padding: '400px 0' }}>
      <Grid>
        <StatefulTimer label="Longer label" defaultValue={null} />
        <StatefulTimer
          label="Longer label"
          defaultValue={{
            id: 1,
            activationDate: date.toISOString(),
            action: 2,
            author: genUser({
              id: 2,
            }),
          }}
        />
        <StatefulTimer label="Longer label" defaultValue={null} />
      </Grid>

      <button>index</button>
    </div>
  );
};

export default {
  title: 'Attribute2/Timer',
  component: Timer,
};
