import { ReadingProps } from '@crm/components/dist/Attribute2/types/ReadingProps';
import { EditingProps } from '@crm/components/dist/Attribute2/types/EditingProps';
import { EntireProps } from '@crm/components/dist/Attribute2/types/EntireProps';
import { StatefulProps } from '@crm/components/dist/Attribute2/types/StatefulProps';
import { User } from '../types/User';
import { Timer } from '../types/Timer';

export type TimerReadingValue = Timer | null;
export type TimerEditingValue = Timer | null;

export interface TimerCommonProps {
  isModalVisible: boolean;
  onExistingTimerClick?: () => void;
}

export type TimerReadingProps = TimerCommonProps & ReadingProps<TimerReadingValue>;
export type TimerEditingProps = TimerCommonProps & EditingProps<TimerEditingValue>;

export interface TimerSubmitValues {
  action?: number;
  comment?: string;
  startDate: string;
  users?: User[];
}
export interface TimerProps
  extends Omit<
    EntireProps<TimerReadingProps, TimerEditingProps>,
    'isModalVisible' | 'onExistingTimerClick'
  > {
  onSubmit?: (values: TimerSubmitValues) => void;
}
export type StatefulTimerProps = StatefulProps<TimerProps>;
