export const prettyDate = (date: Date | string) => {
  let d = typeof date === 'string' ? new Date(date) : date;

  return `${d.toLocaleDateString('ru', {
    day: 'numeric',
    month: 'long',
  })} в ${d.toLocaleTimeString('ru', {
    hour: '2-digit',
    minute: '2-digit',
  })}`;
};

export const actionToString = (action: number): string => {
  if (action === 2) {
    return 'На последнего исполнителя';
  }

  return 'В очередь';
};
