import React, { FC } from 'react';
import { Bubble } from '@crm/components/dist/Bubble';
import { Text } from '@crm/components/dist/lego2/Text';
import { TimerBubbleProps } from './TimerBubble.types';
import { prettyDate } from '../Timer.utils';

export const TimerBubble: FC<TimerBubbleProps> = (props) => {
  const { timer, ...restProps } = props;
  return (
    <Bubble {...restProps}>
      <Text typography="control-m">{prettyDate(timer.activationDate)}</Text>
    </Bubble>
  );
};
