import React, { FC } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import { UserLink } from 'components/UserLink';
import { TimerInfoProps } from './TimerInfo.types';
import css from './TimerInfo.module.css';

export const TimerInfo: FC<TimerInfoProps> = (props) => {
  const { timer } = props;

  return (
    <div className={css.TimerInfo}>
      {timer.comment && (
        <>
          <Text className={css.TimerInfo__header} color="secondary" typography="body-long-s">
            Комментарий
          </Text>
          <Text className={css.TimerInfo__comment} typography="body-long-m">
            {timer.comment}
          </Text>
        </>
      )}
      {Boolean(timer.users?.length) && (
        <>
          <Text className={css.TimerInfo__header} color="secondary" typography="body-long-s">
            Уведомить
          </Text>
          {timer.users?.map((user) => (
            <UserLink className={css.TimerInfo__user} key={user.id} user={user} />
          ))}
        </>
      )}
    </div>
  );
};
