import React, { FC, useCallback, useRef, useEffect } from 'react';
import { MixedItem } from '@yandex-lego/components/Menu';
import { Instance } from '@popperjs/core';
import { PopupMenu } from '@crm/components/dist/PopupMenu';
import { PopupSkillsProps } from './PopupSkills.types';
import { skillValueItems } from './PopupSkills.config';

export const PopupSkills: FC<PopupSkillsProps> = (props) => {
  const {
    isVisible,
    items: outerItems,
    onChange,
    onClose,
    popperRef: outerPopperRef,
    level = 'skill',
    onLevelChange,
    currentSkill,
    onCurrentSkillChange,
  } = props;

  const popperRef = useRef<Instance>();

  useEffect(() => {
    if (!isVisible) {
      onLevelChange?.('skill');
    }
  }, [isVisible]);

  const emitClose = (event: Event, source: string) => {
    onLevelChange?.('skill');

    const isTransitionBackToSkills = source === 'esc' && level === 'value';
    if (isTransitionBackToSkills) {
      return;
    }

    onClose?.(event, source);
  };

  const handlePopperRef = useCallback(
    (instance: Instance) => {
      outerPopperRef?.(instance);
      popperRef.current = instance;
    },
    [outerPopperRef],
  );

  const handleChange = useCallback(
    (value: number | string) => {
      if (level === 'skill') {
        onCurrentSkillChange?.(outerItems?.find((i) => i.id === value)!);
        onLevelChange?.('value');
      }

      if (level === 'value') {
        onChange?.({
          ...currentSkill!,
          value: value as number,
        });
        onLevelChange?.('skill');
      }

      popperRef.current?.update();
    },
    [onChange, level, currentSkill, onCurrentSkillChange, onLevelChange, outerItems],
  );

  let items: MixedItem[] | undefined = props.items?.map((skill) => ({
    value: skill.id,
    content: skill.text,
  }));

  if (level === 'value') {
    items = skillValueItems;
  }

  return (
    <PopupMenu
      {...props}
      popperRef={handlePopperRef}
      onClose={emitClose}
      onChange={handleChange}
      items={items}
    />
  );
};
