import React, { FC } from 'react';
import { TagCollection } from 'components/TagCollection';
import { LoadingPopup } from '@crm/components/dist/LoadingPopup';
import { useValueKeyboardEvent } from '@crm/components/dist/PopupMenu';
import { PopupTagCollectionProps } from './PopupTagCollection.types';

export const PopupTagCollection: FC<PopupTagCollectionProps> = (props) => {
  const {
    isVisible,
    isLoading,
    personal,
    common,
    creationText,
    onChange,
    onCreate,
    popperRef,
    anchor,
    isFocused,
    onClose,
    onEvent,
    scope,
  } = props;

  useValueKeyboardEvent(isFocused, onEvent);

  return (
    <LoadingPopup
      isVisible={isVisible}
      isLoading={isLoading}
      popperRef={popperRef}
      anchor={anchor}
      onClose={onClose}
      scope={scope}
    >
      <TagCollection
        common={common}
        personal={personal}
        creationText={creationText}
        onChange={onChange}
        onCreate={onCreate}
        isFocused={isFocused}
      />
    </LoadingPopup>
  );
};
