import React, { FC } from 'react';
import Link from '@crm/components/dist/lego2/Link';
import { Text } from '@crm/components/dist/lego2/Text';
import getRoutingRoot from 'utils/getRoutingRoot';
import { ReadingRowAccountProps } from './ReadingRowAccount.types';
import css from './ReadingRowAccount.module.css';

export const ReadingRowAccount: FC<ReadingRowAccountProps> = (props) => {
  const { account, asLink = false, onClick } = props;

  return (
    <Link
      className={css.ReadingRowAccount}
      disabled={!asLink}
      href={`${getRoutingRoot()}/account/${account.id}`}
      tabIndex={-1}
      onClick={onClick}
      target="_blank"
    >
      <Text className={css.ReadingRowAccount__text} typography="body-short-m">
        {account.info.name}
      </Text>
    </Link>
  );
};
