import { User } from './User';

interface Services {
  bayan?: boolean;
  direct?: boolean;
  market?: boolean;
  mediasel?: boolean;
  metrika?: boolean;
  sprav?: boolean;
  audience?: boolean;
  balance?: boolean;
  balanceYaTeam?: boolean;
  rsya?: boolean;
  zen?: boolean;
  yaTelephony?: boolean;
}

interface AccountInfo {
  id: number;
  login: string;
  clientId: number;
  name: string;
  type?: string;
  tier?: {
    name: string;
  };
  zenPublisherIds?: (string | number)[];
  yatelMcId: string;
}

export interface SimpleAccount {
  id: number;
  info: AccountInfo;
  managers?: User[];
  services?: Services;
}

export interface Account extends SimpleAccount {
  info: AccountInfo & {
    // FIXME: CRM-17627
    //  пережиток прошлого, на самом деле контрагентов может быть 0 или 1, зачем массив - непонятно
    contractors?: SimpleAccount[];
  };
  agency?: SimpleAccount;
}
