import React, { FC } from 'react';
import {
  AttributesByScheme as Attributes,
  AttributesBySchemeProps,
  ComponentsProperty,
} from '@crm/components/dist/AttributesByScheme';
import { DateTimePicker } from './DateTimePicker';
import { StaffUserInput } from './StaffUserInput';
import { AccountInput } from './AccountInput';
import { Skills } from './Skills';
import { Timers } from './Timers';
import { Suggest } from './Suggest';
import { Tags } from './Tags';
import { Grants } from './Grants';
import { Categorization } from './Categorization';
import { Checkbox } from './Checkbox';
import { OpportunitiesInput } from './OpportunitiesInput';

export const AttributesByScheme: FC<AttributesBySchemeProps> = (props) => {
  const components: ComponentsProperty = {
    ...props?.components,
    AccountInput: {
      render: AccountInput,
      ...props?.components?.AccountInput,
    },
    Categorization: {
      render: Categorization,
      ...props?.components?.Categorization,
    },
    Checkbox: {
      render: Checkbox,
      ...props?.components?.Checkbox,
    },
    DateTimePicker: {
      render: DateTimePicker,
      ...props?.components?.DateTimePicker,
    },
    Grants: {
      render: Grants,
      ...props?.components?.Grants,
    },
    OpportunitiesInput: {
      render: OpportunitiesInput,
      ...props?.components?.OpportunitiesInput,
    },
    Skills: {
      render: Skills,
      ...props?.components?.Skills,
    },
    StaffUserInput: {
      render: StaffUserInput,
      ...props?.components?.StaffUserInput,
    },
    Suggest: {
      render: Suggest,
      ...props?.components?.Suggest,
    },
    Tags: {
      render: Tags,
      ...props?.components?.Tags,
      getProps: (attribute) => ({
        url: attribute?.fieldProps?.provider || '',
        ...props?.components?.Tags?.getProps?.(attribute),
      }),
    },
    Timers: {
      render: Timers,
      ...props?.components?.Timers,
    },
  };

  return <Attributes {...props} components={components} />;
};
