import { EObject } from 'types/entities';
import {
  DateEditingValue,
  StaffSuggestEditingValue,
  AccountEditingValue,
  StaffSuggestMultipleEditingValue,
  TimerEditingValue,
  SkillsEditingValue,
  TagsEditingValue,
  AccountFeatureFlags,
  OpportunitiesEditingValue,
  OpportunitiesInputProps,
} from 'components/Attribute2';
import { SuggestSelectEditingValue } from '@crm/components/dist/Attribute2/SuggestSelect/SuggestSelect.types';
import { SelectEditingValue } from '@crm/components/dist/Attribute2/Select';
import { TextinputEditingValue } from '@crm/components/dist/Attribute2/Textinput';
import {
  AttributeComponentCallbackProps,
  AttributesSchemeRow,
} from '@crm/components/dist/AttributesByScheme';
import { IdNameCategory, CategorizationInitialize } from './Categorization';
import { IdNameTag } from './Tags';

interface HasProviderUrl {
  provider: string;
}
export type CanHaveProviderUrl = Partial<HasProviderUrl>;

export interface HasIdNameItems {
  items: { id: number | string; name: string }[];
}
export type CanHaveIdNameItems = Partial<HasIdNameItems>;

export type AttributesSchemeRowCheckbox = AttributesSchemeRow<'Checkbox'>;

export type AttributesSchemeRowDateTimePicker = AttributesSchemeRow<
  'DateTimePicker',
  {
    minDate?: string;
    time?: boolean;
  }
>;

export type AttributesSchemeRowStaffUserInput = AttributesSchemeRow<'StaffUserInput'>;
export type AttributesSchemeRowTextinput = AttributesSchemeRow<
  'TextInput',
  {
    isMultiline?: boolean;
  }
>;
export type AttributesSchemeRowSuggest = AttributesSchemeRow<
  'Suggest',
  HasProviderUrl & {
    canDelete?: boolean;
  }
>;
export type AttributesSchemeRowCategorization = AttributesSchemeRow<
  'Categorization',
  HasProviderUrl
>;
export type AttributesSchemeRowSelect = AttributesSchemeRow<
  'Select',
  CanHaveProviderUrl & CanHaveIdNameItems
>;
export type AttributesSchemeRowAccountInput = AttributesSchemeRow<
  'AccountInput',
  AccountFeatureFlags
>;
export type AttributesSchemeRowTags = AttributesSchemeRow<'Tags', HasProviderUrl>;
export type AttributesSchemeRowGrants = AttributesSchemeRow<'Grants'>;
export type AttributesSchemeRowTimers = AttributesSchemeRow<'Timers'>;
export type AttributesSchemeRowSkills = AttributesSchemeRow<'Skills'>;
export type AttributesSchemeRowOpportunitiesInput = AttributesSchemeRow<
  'OpportunitiesInput',
  HasProviderUrl
>;

export type AttributesScheme = AttributesSchemeRow[];

export interface HasEObject {
  EObject: EObject;
}
export type CanHaveEObject = Partial<HasEObject>;

type ChangeHandler<A extends AttributesSchemeRow, V = unknown> = (
  attribute: A,
  value: V,
) => Promise<void | void[]>;

export type DateTimePickerChangeHandler = ChangeHandler<
  AttributesSchemeRowDateTimePicker,
  DateEditingValue
>;
export type StaffUserInputChangeHandler = ChangeHandler<
  AttributesSchemeRowStaffUserInput,
  StaffSuggestEditingValue
>;
export type TextInputChangeHandler = ChangeHandler<
  AttributesSchemeRowTextinput,
  TextinputEditingValue
>;
export type SuggestChangeHandler = ChangeHandler<
  AttributesSchemeRowSuggest,
  SuggestSelectEditingValue
>;
export type CategorizationChangeHandler = ChangeHandler<AttributesSchemeRowCategorization, number>;
export type SelectChangeHandler = ChangeHandler<AttributesSchemeRowSelect, SelectEditingValue>;
export type AccountInputChangeHandler = ChangeHandler<
  AttributesSchemeRowAccountInput,
  number | string | null
>;
export type TagsChangeHandler = ChangeHandler<AttributesSchemeRowTags, TagsEditingValue>;
export type GrantsChangeHandler = ChangeHandler<
  AttributesSchemeRowGrants,
  StaffSuggestMultipleEditingValue
>;
export type TimersChangeHandler = ChangeHandler<AttributesSchemeRowTimers, TimerEditingValue>;
export type SkillsChangeHandler = ChangeHandler<AttributesSchemeRowSkills, SkillsEditingValue>;
export type OpportunitiesInputChangeHandler = ChangeHandler<AttributesSchemeRowOpportunitiesInput>;
export type CheckboxChangeHandler = ChangeHandler<AttributesSchemeRowCheckbox>;

export interface AttributesChangeHandlers {
  onDateTimePickerChange?: DateTimePickerChangeHandler;
  onStaffUserInputChange?: StaffUserInputChangeHandler;
  onTextInputChange?: TextInputChangeHandler;
  onSuggestChange?: SuggestChangeHandler;
  onCategorizationChange?: CategorizationChangeHandler;
  onSelectChange?: SelectChangeHandler;
  onAccountInputChange?: AccountInputChangeHandler;
  onTagsChange?: TagsChangeHandler;
  onGrantsChange?: GrantsChangeHandler;
  onTimersChange?: TimersChangeHandler;
  onSkillsChange?: SkillsChangeHandler;
  onOpportunitiesInputChange?: OpportunitiesInputChangeHandler;
  onCheckboxChange?: CheckboxChangeHandler;
}

type GetAttributeCallback<A extends AttributesSchemeRow, R = unknown> = (attribute: A) => R;
type GetAttributeCallbackCommon<A extends AttributesSchemeRow, V = unknown> = GetAttributeCallback<
  A,
  AttributeComponentCallbackProps<V>
>;

export type GetDateTimePicker = GetAttributeCallbackCommon<
  AttributesSchemeRowDateTimePicker,
  DateEditingValue
>;
export type GetStaffUserInput = GetAttributeCallbackCommon<
  AttributesSchemeRowStaffUserInput,
  StaffSuggestEditingValue
>;
export type GetTextInput = GetAttributeCallbackCommon<
  AttributesSchemeRowTextinput,
  TextinputEditingValue
>;
export type GetSuggest = GetAttributeCallbackCommon<
  AttributesSchemeRowSuggest,
  SuggestSelectEditingValue
>;
export type GetCategorization = GetAttributeCallback<
  AttributesSchemeRowCategorization,
  AttributeComponentCallbackProps<IdNameCategory> & {
    onInitialize: CategorizationInitialize;
  }
>;
export type GetSelect = GetAttributeCallbackCommon<AttributesSchemeRowSelect, SelectEditingValue>;
export type GetAccountInput = GetAttributeCallback<
  AttributesSchemeRowAccountInput,
  AttributeComponentCallbackProps<AccountEditingValue> & {
    featureFlags?: AccountFeatureFlags;
  }
>;
export type GetTags = GetAttributeCallbackCommon<AttributesSchemeRowTags, IdNameTag[]>;
export type GetGrants = GetAttributeCallbackCommon<
  AttributesSchemeRowGrants,
  StaffSuggestMultipleEditingValue
>;
export type GetTimers = GetAttributeCallbackCommon<AttributesSchemeRowTimers, TimerEditingValue>;
export type GetSkills = GetAttributeCallbackCommon<AttributesSchemeRowSkills, SkillsEditingValue>;
export type GetOpportunitiesInput = GetAttributeCallback<
  AttributesSchemeRowOpportunitiesInput,
  AttributeComponentCallbackProps<OpportunitiesEditingValue> & OpportunitiesInputProps
>;
export type GetCheckbox = GetAttributeCallbackCommon<AttributesSchemeRowCheckbox, boolean>;

export type GetCommon = (
  attribute: AttributesSchemeRow,
) => Partial<AttributeComponentCallbackProps<unknown>>;

export type CommonChangeHandler = (attribute: AttributesSchemeRow, value: unknown) => Promise<void>;
