import React, { FC, useCallback } from 'react';
import { CheckboxAttribute } from 'components/Attribute2/Checkbox';
import { AttributeComponentProps } from '@crm/components/dist/AttributesByScheme';

export const Checkbox: FC<AttributeComponentProps> = (props) => {
  const { attribute, onChange, isDisabled } = props;
  const value = props.value as boolean;

  const handleChange = useCallback(
    async (value: boolean) => {
      await onChange(attribute, value);
    },
    [attribute, onChange],
  );

  return (
    <CheckboxAttribute
      label={attribute.label}
      onChange={handleChange}
      isDisabled={isDisabled}
      value={value}
    />
  );
};
