import React, { useState, useCallback, FC } from 'react';
import { Date, DateEditingValue } from 'components/Attribute2';
import { Event } from 'types/Event';
import toLocalISOString from 'utils/date/toLocalISOString';
import { AttributeComponentProps } from '@crm/components/dist/AttributesByScheme';

export const DateTimePicker: FC<AttributeComponentProps & {
  minDate?: string | Date;
  canShowTime?: boolean;
}> = (props) => {
  const { attribute, onChange, isDisabled, onEvent, minDate, canShowTime } = props;
  const value = (props.value as DateEditingValue) || null;
  const [isReadingLoading, setReadingLoading] = useState(false);
  const [isEditing, setEditing] = useState(false);

  const emitEvent = useCallback(
    (event: Event) => {
      onEvent?.(attribute, event);
    },
    [onEvent],
  );

  const handleChange = useCallback(
    async (rawValue: DateEditingValue) => {
      setReadingLoading(true);
      const newValue = rawValue ? toLocalISOString(new window.Date(rawValue)) : null;

      try {
        await onChange(attribute, newValue);
      } finally {
        setReadingLoading(false);
      }
    },
    [onChange, emitEvent],
  );

  return (
    <Date
      label={attribute.label}
      name={attribute.name}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      isReadingLoading={isReadingLoading}
      onChange={handleChange}
      isDisabled={isDisabled}
      onEvent={emitEvent}
      minDate={minDate}
      canShowTime={canShowTime}
    />
  );
};
