import React, { useState, useCallback, FC } from 'react';
import { get } from 'entry/api/common';
import { SuggestStaffInline2 } from 'lego/components/SuggestStaff';
import { StaffSuggestMultiple, StaffSuggestMultipleEditingValue } from 'components/Attribute2';
import { Event } from 'types/Event';
import { useSelector } from 'react-redux';
import { getCurrentUser } from 'entry/store/selectors';
import { AttributeComponentProps } from '@crm/components/dist/AttributesByScheme';
import { EObject } from 'types/entities';

export const Grants: FC<AttributeComponentProps & {
  EObject?: EObject;
}> = (props) => {
  const { attribute, onChange, isDisabled, EObject, onEvent } = props;
  const value = (props.value as StaffSuggestMultipleEditingValue) || [];
  const [isReadingLoading, setReadingLoading] = useState(false);
  const [isEditing, setEditing] = useState(false);

  const currentUser = useSelector(getCurrentUser);

  const emitEvent = useCallback(
    (event: Event) => {
      onEvent?.(attribute, event);
    },
    [onEvent],
  );

  const handleChange = useCallback(
    async (newValue: StaffSuggestMultipleEditingValue) => {
      setReadingLoading(true);
      try {
        await onChange(attribute, newValue);
      } finally {
        setReadingLoading(false);
      }
    },
    [onChange],
  );

  const handleLoad = async (text: string) => {
    const eObj = EObject
      ? {
          eType: EObject.etype,
          eId: EObject.eid,
        }
      : null;

    const response = await get({
      url: '/suggest/staff',
      data: {
        text,
        variant: SuggestStaffInline2.StaffSuggestVariant.UsersOnly,
        onlyUserHadAnyRole: true,
        onlyUserActive: true,
        isSingleValue: true,
        ...eObj,
      },
    });

    return response.items.map((item) => response.map.users[item.eId]);
  };

  return (
    <StaffSuggestMultiple
      label={attribute.label}
      name={attribute.name}
      isEditing={isEditing}
      onEditingChange={setEditing}
      isReadingLoading={isReadingLoading}
      readingValue={value}
      editingValue={value}
      onChange={handleChange}
      currentUser={currentUser}
      mergeCurrentUserIntoList
      isDisabled={isDisabled}
      onLoad={handleLoad}
      onEvent={emitEvent}
    />
  );
};
