import React, { useState, useCallback, FC } from 'react';
import {
  OpportunitiesEditingValue,
  Opportunities,
  OpportunitiesReadingValue,
} from '../../Attribute2';
import { AttributeComponentProps } from '@crm/components/dist/AttributesByScheme';
import { Account } from 'components/Attribute2/types/Account';

export const OpportunitiesInput: FC<AttributeComponentProps & {
  account?: Account;
  provider?: string;
}> = (props) => {
  const { attribute, onChange, isDisabled, account, provider } = props;
  const value = (props.value as OpportunitiesReadingValue) || {};
  const [isEditing, setEditing] = useState(false);
  const [isReadingLoading, setReadingLoading] = useState(false);

  const handleChange = useCallback(
    async (newOpportunitiesValue: OpportunitiesEditingValue) => {
      setReadingLoading(true);
      if (isEditing) {
        setEditing(false);
      }
      try {
        await onChange(attribute, newOpportunitiesValue);
      } finally {
        setReadingLoading(false);
      }
    },
    [attribute, isEditing, onChange],
  );

  return (
    <Opportunities
      label={attribute.label}
      name={attribute.name}
      provider={provider}
      isReadingLoading={isReadingLoading}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      onChange={handleChange}
      isDisabled={isDisabled}
      account={account}
    />
  );
};
