import React, { useState, useCallback, FC } from 'react';
import { get } from 'entry/api/common';
import { SuggestStaffInline2 } from 'lego/components/SuggestStaff';
import { StaffSuggest, StaffSuggestEditingValue } from 'components/Attribute2';
import { useSelector } from 'react-redux';
import { getCurrentUser } from 'entry/store/selectors';
import { Event } from '@crm/components/dist/types/Event';
import { AttributeComponentProps } from '@crm/components/dist/AttributesByScheme';
import { EObject } from 'types/entities';

export const StaffUserInput: FC<AttributeComponentProps & {
  EObject?: EObject;
}> = (props) => {
  const { attribute, onChange, isDisabled, EObject, onEvent } = props;
  const value = (props.value as StaffSuggestEditingValue) || null;
  const [isReadingLoading, setReadingLoading] = useState(false);
  const [isEditing, setEditing] = useState(false);

  const currentUser = useSelector(getCurrentUser);

  const emitEvent = useCallback(
    (event: Event) => {
      onEvent?.(attribute, event);
    },
    [onEvent],
  );

  const handleChange = useCallback(
    async (newValue: StaffSuggestEditingValue) => {
      setReadingLoading(true);
      try {
        await onChange(attribute, newValue || null);
      } finally {
        setReadingLoading(false);
      }
    },
    [onChange],
  );

  const handleLoad = async (text: string) => {
    const eObj = EObject
      ? {
          eType: EObject.etype,
          eId: EObject.eid,
        }
      : null;

    const response = await get({
      url: '/suggest/staff',
      data: {
        text,
        variant: SuggestStaffInline2.StaffSuggestVariant.UsersOnly,
        onlyUserHadAnyRole: true,
        onlyUserActive: true,
        isSingleValue: true,
        ...eObj,
      },
    });

    return response.items.map((item) => response.map.users[item.eId]);
  };

  return (
    <StaffSuggest
      label={attribute.label}
      name={attribute.name}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      isReadingLoading={isReadingLoading}
      isDisabled={isDisabled}
      onChange={handleChange}
      currentUser={currentUser}
      mergeCurrentUserIntoList
      onLoad={handleLoad}
      onEvent={emitEvent}
    />
  );
};
