import React, { useState } from 'react';
import { storiesOf } from '@storybook/react';
import { Audio } from './Audio';

const AudioStories = () => {
  const [src, setSrc] = useState('');

  const handleChange = (e) => {
    let file = e.target.files[0];
    let url = URL.createObjectURL(file);
    setSrc(url);
  };

  return (
    <>
      <div>Загрузка локального аудиофайла</div>
      <input onChange={handleChange} type="file" accept="audio/*" />
      {src ? <Audio src={src} /> : null}
    </>
  );
};

storiesOf('Audio', module).add('Audio', () => <AudioStories />);
