import React from 'react';
import { FormattedDate } from 'react-intl';
import cx from 'classnames';
import { TimeProgressProps } from './TimeProgress.types';
import { time2Value, value2Time } from './TimeProgress.utils';
import { MAX_PROGRESS_VALUE } from './TimeProgress.constants';

import css from './TimeProgress.module.css';

const TimeProgress: React.FC<TimeProgressProps> = ({
  duration,
  currentTime,
  setTime,
  className,
}) => {
  const value = time2Value(currentTime, duration, MAX_PROGRESS_VALUE);

  const onChange = (e) => {
    setTime(value2Time(e.target.value, duration, MAX_PROGRESS_VALUE));
  };

  const formatTime = (time) => (
    <FormattedDate minute="numeric" second="numeric" value={new Date(time * 1000)} />
  );

  return (
    <div className={cx(css.TimeProgress, className)}>
      <input
        className={css.TimeProgress__input}
        data-testid="time-progress"
        type="range"
        min={0}
        max={MAX_PROGRESS_VALUE}
        value={value}
        onChange={onChange}
      />
      <span data-testid="currentTime" className={css.TimeProgress__time}>
        {formatTime(currentTime)}/{formatTime(duration)}
      </span>
    </div>
  );
};

export { TimeProgress };
