import { ErrorObject } from '../../Audio.types';

export const doesRecordNeverExists = (error: { status: number }): boolean => {
  return error.status === 410;
};

export const recordNeverExistsError = (message?: string): ErrorObject => ({
  message: message || 'Запись отсутствует',
  canRetry: false,
});

export const isRecordNotReadyYet = (error: { status: number }): boolean => {
  return error.status === 404;
};

export const notReadyRecordError = (message?: string): ErrorObject => ({
  message: message || 'Данные из телефонии еще не получены',
  canRetry: true,
});

export const canInterpretError = (error: unknown): boolean => {
  return (
    Boolean(error && (error as { status?: number }).status) &&
    Boolean((error as { data?: string | unknown }).data) &&
    typeof (error as { data?: string | unknown }).data === 'string'
  );
};

export const internalError = (message?: string): ErrorObject => ({
  message: message || 'Произошла ошибка',
  canRetry: true,
});

export const interpretError = (error: { data?: string; status: number }): ErrorObject => {
  if (doesRecordNeverExists(error)) {
    return recordNeverExistsError(error.data);
  }

  if (isRecordNotReadyYet(error)) {
    return notReadyRecordError(error.data);
  }

  return internalError(error.data);
};
