// Mock data and helper methods
// @ts-ignore
window.HTMLMediaElement.prototype._mock = {
  paused: true,
  duration: NaN,
  _loaded: false,
  // Emulates the audio file loading
  _load: jest.fn(function audioInit(audio) {
    let audioElement = audio || this;
    // Note: we could actually load the file from this.src and get real duration
    // and other metadata.
    // See for example: https://github.com/59naga/mock-audio-element/blob/master/src/index.js
    // For now, the 'duration' and other metadata has to be set manually in test code.
    audioElement.dispatchEvent(new Event('loadedmetadata'));
    audioElement.dispatchEvent(new Event('canplaythrough'));
  }),
  // Reset audio object mock data to the initial state
  _resetMock: function resetMock(audio) {
    // @ts-ignore
    audio._mock = Object.assign({}, window.HTMLMediaElement.prototype._mock);
  },
};

// Get "paused" value, it is automatically set to true / false when we play / pause the audio.
Object.defineProperty(window.HTMLMediaElement.prototype, 'paused', {
  get() {
    return this._mock.paused;
  },
});

// Get and set audio duration
Object.defineProperty(window.HTMLMediaElement.prototype, 'duration', {
  get() {
    return this._mock.duration;
  },
  set(value) {
    // Reset the mock state to initial (paused) when we set the duration.
    this._mock._resetMock(this);
    this._mock.duration = value;
  },
});

// Start the playback.
window.HTMLMediaElement.prototype.play = function playMock() {
  if (!this._mock._loaded) {
    // emulate the audio file load and metadata initialization
    this._mock._load(this);
  }
  this._mock.paused = false;
  this.dispatchEvent(new Event('play'));

  return Promise.resolve();
};

// Pause the playback
window.HTMLMediaElement.prototype.pause = function pauseMock() {
  this._mock.paused = true;
  this.dispatchEvent(new Event('pause'));
};

// @ts-ignore
window.HTMLMediaElement.prototype.load = window.HTMLMediaElement.prototype._mock._load;
