import React, { useState } from 'react';
import { storiesOf } from '@storybook/react';
import { StatefulAudioSource as AudioSource } from './StatefulAudioSource';

const AudioSourceStories = () => {
  const [src, setSrc] = useState('');

  const handleChange = (e) => {
    let file = e.target.files[0];
    let url = URL.createObjectURL(file);
    setSrc(url);
  };

  return (
    <>
      <div>Загрузка локального аудиофайла</div>
      <input onChange={handleChange} type="file" accept="audio/*" />
      {src ? <AudioSource src={src} /> : null}
    </>
  );
};

storiesOf('Audio', module).add('Audio', () => <AudioSourceStories />);
