export interface ErrorObject {
  message?: string;
  canRetry?: boolean;
}

export type MetaState = Record<string, ErrorObject | null>;

export interface MetaStateContextValue {
  get: (metaSrc: string) => ErrorObject | null;
  set: (metaSrc: string, value: ErrorObject | null) => void;
}

export interface AudioSourceState {
  canAudioInteract: boolean;
  isMetaValid: boolean;
  isMetaLoading: boolean;
  error: ErrorObject | null;
}

export interface AudioSourceProps {
  audio: HTMLAudioElement;
  src?: string;
  metaSrc?: string;
  metaCacheClearKey?: string;
  keepPlayOnUnmount?: boolean;
}
