import React, { FC } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { ErrorMessageProps } from './ErrorMessage.types';
import css from './ErrorMessage.module.css';

export const ErrorMessage: FC<ErrorMessageProps> = ({ message, canRetry = false, onRetry }) => {
  return (
    <div className={css.ErrorMessage}>
      {message}
      {canRetry && (
        <Button className={css.ErrorMessage__retryButton} onClick={onRetry}>
          Попробовать еще раз
        </Button>
      )}
    </div>
  );
};
