import { MetaObject } from './MetaCache.types';

export class MetaCache {
  private map = new Map<string, MetaObject | null>();

  private static clearKey: string = '';

  private static instance: MetaCache;

  public static create(): MetaCache {
    if (!MetaCache.instance) {
      MetaCache.instance = new MetaCache();
    }
    return MetaCache.instance;
  }

  public get(metaSrc: string): MetaObject | null {
    if (!this.map.has(metaSrc)) {
      return null;
    }

    return this.map.get(metaSrc)!;
  }

  public set(metaSrc: string, metaObject: MetaObject) {
    this.map.set(metaSrc, metaObject);
  }

  public keepCacheValidForClearKey(clearKey: string) {
    if (this.isSameClearKey(clearKey)) {
      return;
    }

    this.setClearKey(clearKey);
    this.clear();
  }

  private isSameClearKey(clearKey: string): boolean {
    return clearKey === MetaCache.clearKey;
  }

  private setClearKey(clearKey: string) {
    MetaCache.clearKey = clearKey;
  }

  private clear() {
    this.map.clear();
  }

  public remove(metaSrc: string): void {
    this.map.delete(metaSrc);
  }
}
