import React, { FC, useState, useEffect } from 'react';
import { AudioSource } from '../AudioSource';
import { StatefulAudioSourceProps } from './StatefulAudioSource.types';

export const StatefulAudioSource: FC<StatefulAudioSourceProps> = (props) => {
  const [audio] = useState(new Audio());

  useEffect(() => () => audio.pause(), []);

  return <AudioSource {...props} audio={audio} />;
};
