// Mock data and helper methods
// @ts-ignore
window.HTMLMediaElement.prototype._mock = {
  paused: true,
  duration: NaN,
};

// Get "paused" value, it is automatically set to true / false when we play / pause the audio.
Object.defineProperty(window.HTMLMediaElement.prototype, 'paused', {
  get() {
    return this._mock.paused;
  },
});

// Get and set audio duration
Object.defineProperty(window.HTMLMediaElement.prototype, 'duration', {
  get() {
    return this._mock.duration;
  },
  set(value) {
    // Reset the mock state to initial (paused) when we set the duration.
    this._mock._resetMock(this);
    this._mock.duration = value;
  },
});

// Start the playback.
window.HTMLMediaElement.prototype.play = function playMock() {
  this._mock.paused = false;
  this.dispatchEvent(new Event('play'));

  return Promise.resolve();
};

// Pause the playback
window.HTMLMediaElement.prototype.pause = function pauseMock() {
  this._mock.paused = true;
  this.dispatchEvent(new Event('pause'));
};
