import React from 'react';
import { storiesOf } from '@storybook/react';
import Avatar, { AvatarUser } from './Avatar';
import { avatarService } from './index';

const user: AvatarUser = {
  id: 1,
  login: 'crm',
  name: 'CRM',
  first_name: 'Ivan',
  last_name: 'Petrov',
};

const userWithoutLastName: AvatarUser = {
  id: 2,
  login: 'crm',
  name: '',
  first_name: 'Ivan',
};

const userWithoutFirstName: AvatarUser = {
  id: 3,
  login: 'crm',
  name: '',
  last_name: 'Petrov',
};

const userWithName: AvatarUser = {
  id: 4,
  login: 'with-name',
  name: 'With Name',
};

const userWithOnlyLogin: AvatarUser = {
  id: 4,
  login: 'only-login',
  name: 'Only Login',
};

interface AvatarStoriesProps {
  isAvailable: boolean;
}

class AvatarStories extends React.Component<AvatarStoriesProps> {
  public constructor(props) {
    super(props);

    avatarService.setAvailable(props.isAvailable);
  }

  public render() {
    return (
      <>
        <h1>Аватар без картинки</h1>

        <h2>Пользователь с именем и фамилией</h2>
        <Avatar user={user} />

        <h2>Пользователь с именем</h2>
        <Avatar user={userWithoutLastName} />

        <h2>Пользователь с фамилией</h2>
        <Avatar user={userWithoutFirstName} />

        <h2>Пользователь с полем name</h2>
        <Avatar user={userWithName} />

        <h2>Пользователь только с логином</h2>
        <Avatar user={userWithOnlyLogin} />
      </>
    );
  }
}

storiesOf('Avatar', module).add('Img avatar', () => <AvatarStories isAvailable />);

storiesOf('Avatar', module).add('Text avatar', () => <AvatarStories isAvailable={false} />);
