import Color from 'color';

const map = new Map();

const stringToColour = str => {
  let hash = 0;
  for (let i = 0; i < str.length; i += 1) {
    hash = str.charCodeAt(i) + ((hash << 5) - hash);
  }
  let colour = '#';
  for (let i = 0; i < 3; i += 1) {
    const value = (hash >> (i * 8)) & 0xff;
    colour += `00${value.toString(16)}`.substr(-2);
  }
  return colour;
};

const getTextColor = color => {
  const c = new Color(color);

  return c.isLight() ? 'black' : 'white';
};

export default str => {
  let result = map.get(str);
  if (!result) {
    const backgroundColor = stringToColour(str);
    const color = getTextColor(backgroundColor);

    result = { backgroundColor, color };
    map.set(str, result);
  }

  return result;
};
