import { useMemo } from 'react';
import { AvatarUser } from './Avatar';
import { isExternalUser } from '../../utils/isExternalUser';
import { avatarService, externalAvatarService } from './AvatarService';
import { getLogin } from '../../utils/getLogin';

export const useAvatarService = (user: AvatarUser, login?: string) => {
  const isExternal = isExternalUser(user);

  const service = useMemo(() => {
    return isExternal ? externalAvatarService : avatarService;
  }, [isExternal]);

  const srcSet = useMemo(() => {
    const userLogin = getLogin({ user, login });
    const entity = isExternalUser(user) ? user.avatarId : userLogin;

    return service.getSrcSet(entity);
  }, [login, service, user]);

  const isServiceAvailable = service.isAvailable;

  return { srcSet, isServiceAvailable, service };
};
