import React from 'react';
import PropTypes from 'prop-types';
import lang from 'constants/lang';

class BeforeUnload extends React.Component {
  static propTypes = {
    component: PropTypes.oneOfType([PropTypes.func, PropTypes.string]),
    message: PropTypes.string,
    isPreventUnloud: PropTypes.bool,
  }

  static defaultProps = {
    component: undefined,
    message: lang.CHANGE_LOCATION,
    isPreventUnloud: true,
  }

  componentDidMount() {
    window.addEventListener('beforeunload', this.handleOnExit);
  }

  componentWillUnmount() {
    window.removeEventListener('beforeunload', this.handleOnExit);
  }

  handleOnExit = (e) => {
    const { message, isPreventUnloud } = this.props;

    if (isPreventUnloud) {
      (e || window.event).returnValue = message; // Gecko + IE
      return message; // Webkit, Safari, Chrome etc.
    }

    return undefined;
  }

  render() {
    const {
      component,
      message,
      isPreventUnloud,
      ...passPropsThrough
    } = this.props;

    if (component) {
      return React.createElement(component, passPropsThrough);
    }

    return null;
  }
}

export default BeforeUnload;
