import { BubbleProps } from 'components/Bubble/Bubble.types';

export type Bubble = Pick<BubbleProps, 'color' | 'canDelete'> & {
  id: number | string;
  text: string | number;
};
export type RenderBubble<T extends {} = Bubble> = (
  bubble: T,
  props: BubbleProps,
) => React.ReactElement;

export interface BubbleInputProps<T extends {} = Bubble> {
  display?: boolean;
  text?: string;
  placeholder?: string;
  isMultiline?: boolean;
  onTextChange?: (text: string) => void;
  getKey?: (bubble: T) => string | number;
  bubbles?: T[];
  onBubbleDelete?: (bubble: T) => void;
  onFocusedIndexChange?: (index: number) => void;
  renderBubble?: RenderBubble<T>;
  hasClear?: boolean;
  canUseKeyboard?: boolean;
  canDelete?: boolean;
  tabIndex?: number;
  autoFocus?: boolean;
  innerRef?: (element: HTMLDivElement) => void;
  contentEditableRef?: (element: HTMLDivElement) => void;
  isContentEditableDisabled?: boolean;
}
