import React, { FC } from 'react';
import cx from 'classnames';
import { BubblesContainerProps } from './BubblesContainer.types';
import css from './BubblesContainer.module.css';

export const BubblesContainer: FC<BubblesContainerProps> = (props) => {
  const { innerRef, ...restProps } = props;
  const className = cx(css.BubblesContainer, props.className);

  return (
    <div {...restProps} ref={innerRef} className={className}>
      {props.children}
    </div>
  );
};
