import { Event as BigCalendarEvent, View } from 'react-big-calendar';
import { ComponentType } from 'react';
import { EventProps, Event } from './Event/Event.types';

export interface CalendarProps {
  className?: string;
  date: Date;
  onNavigate?: (date: Date) => void;
  view?: View;
  onView?: (view: View) => void;
  events?: Event[];
  components?: {
    event?: ComponentType<EventProps>;
  };
  onEventSelect?: (event: BigCalendarEvent) => void;
  onRangeChange?: (dateRange: [Date, Date]) => void;
  onEventEdit?: (event: Event) => void;
  onEventDelete?: (event: Event) => void;
  eventMinHeight?: number;
  toolbar?: boolean;
}
