import { EventWrapperProps } from 'react-big-calendar';

export interface Event {
  id: string;
  title: string;
  start: Date;
  end: Date;
  editingUrl: string;
  disabled?: boolean;
  color?: string;
}

export interface EventProps extends Omit<EventWrapperProps, 'style'> {
  type: 'date' | 'time';
  event: Event;
  style?: {
    width: number | string;
    height: number | string;
    top: number | string;
    xOffset: number | string;
  };
}
