import { CSSProperties } from 'react';
import { EventProps } from './Event.types';

export const normalizeStyle = (style: EventProps['style']): CSSProperties => {
  const { width, height, top, xOffset } = style || {};

  return {
    width: typeof width === 'string' ? width : `${width}%`,
    height: typeof height === 'string' ? height : `${height}%`,
    top: `${top}%`,
    left: typeof xOffset === 'string' ? xOffset : `${Math.max(0, xOffset || 0)}%`,
  };
};
