import React, { FC, useState } from 'react';
import { Calendar } from '../Calendar';
import { StatefulCalendarProps } from './StatefulCalendar.types';

export const StatefulCalendar: FC<StatefulCalendarProps> = (props) => {
  const [date, setDate] = useState(new Date());

  const handleNavigate = (date: Date) => {
    setDate(date);
    if (props.onNavigate) {
      props.onNavigate(date);
    }
  };

  return <Calendar {...props} date={date} onNavigate={handleNavigate} />;
};
