import { View } from '@crm/react-big-calendar';
import { endOfDay } from 'date-fns';

export const adaptRange = (range, view: View): [Date, Date] => {
  if (view === 'month') {
    return [range.start, range.end];
  }

  if (view === 'week') {
    return [range[0], endOfDay(range[6])];
  }

  const [dayDate] = range;
  return [dayDate, endOfDay(dayDate)];
};
