import React from 'react';
import PropTypes from 'prop-types';
import CalendarEventParticipant from './CalendarEventParticipant';

const CalendarEventAttendees = (props) => {
  const {
    attendees,
  } = props;

  if (!Array.isArray(attendees)) {
    return null;
  }

  const renderAttendees = [];
  attendees.forEach((attendee, index) => {
    renderAttendees.push(<CalendarEventParticipant key={attendee.commonName} {...attendee} />);
    if (index !== (attendee.length - 1)) {
      renderAttendees.push(<span key={`${attendee.commonName}_delimiter`}>, </span>);
    }
  });

  return (
    <span>{renderAttendees}</span>
  );
};

CalendarEventAttendees.propTypes = {
  attendees: PropTypes.arrayOf(PropTypes.shape(CalendarEventParticipant.propTypes)),
};

CalendarEventAttendees.defaultProps = {
  attendees: undefined,
};

export default CalendarEventAttendees;
