import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';
import css from './CalendarEvent.modules.scss';

const CalendarEventDate = (props) => {
  const {
    startTime,
    startTimeZone,
    endTime,
    endTimeZone,
    duration,
  } = props;

  if (!startTime && !endTime) {
    return null;
  }

  let startTimeRender;
  if (startTime) {
    startTimeRender = (
      <span>
        С&nbsp;
        <FormattedDate
          value={startTime}
          year="numeric"
          month="numeric"
          day="numeric"
          hour="numeric"
          minute="numeric"
        />
        {
          startTimeZone &&
          (!endTime || startTimeZone !== endTimeZone) &&
          (
            <span className={css.CalendarEventParticipant__zone}>&nbsp;({startTimeZone})</span>
          )
        }
      </span>
    );
  }

  let endTimeRender;
  if (endTime) {
    endTimeRender = (
      <span>
        {
          startTime ?
            <span>&nbsp;до&nbsp;</span> :
            <span>До&nbsp;</span>
        }
        <FormattedDate
          value={endTime}
          year="numeric"
          month="numeric"
          day="numeric"
          hour="numeric"
          minute="numeric"
        />
        {
          endTimeZone &&
          (
            <span className={css.CalendarEventParticipant__zone}>&nbsp;({endTimeZone})</span>
          )
        }
      </span>
    );
  }

  return (
    <div>
      {startTimeRender}
      {endTimeRender}
    </div>
  );
};

CalendarEventDate.propTypes = {
  startTime: PropTypes.string,
  startTimeZone: PropTypes.string,
  endTime: PropTypes.string,
  endTimeZone: PropTypes.string,
  duration: PropTypes.string,
};

CalendarEventDate.defaultProps = {
  startTime: undefined,
  startTimeZone: undefined,
  endTime: undefined,
  endTimeZone: undefined,
  duration: undefined,
};

export default CalendarEventDate;
